import React, { useState } from 'react';
import { Routes, Route, useNavigate } from 'react-router-dom';
import HomePage from './pages/HomePage';
import CalculatorPage from './pages/CalculatorPage';
import ResultsPage from './pages/ResultsPage';
import OffsettingPage from './pages/OffsettingPage';
import MethodologyPage from './pages/MethodologyPage';
import Header from './components/layout/Header';
import Footer from './components/layout/Footer';
import './styles/variables.css';
import './styles/components/layout.css';

function App() {
  const [calculationResults, setCalculationResults] = useState(null);
  const navigate = useNavigate();
  
  const handleCalculationComplete = (results) => {
    setCalculationResults(results);
    navigate('/results');
  };
  
  return (
    <>
      <Header />
      <main>
        <Routes>
          <Route path="/" element={<HomePage />} />
          <Route 
            path="/calculator" 
            element={<CalculatorPage onCalculationComplete={handleCalculationComplete} />} 
          />
          <Route 
            path="/results" 
            element={<ResultsPage results={calculationResults} />} 
          />
          <Route path="/offsetting" element={<OffsettingPage />} />
          <Route path="/methodology" element={<MethodologyPage />} />
        </Routes>
      </main>
      <Footer />
    </>
  );
}

export default App;
