import React, { useState } from 'react';
import { useNavigate } from 'react-router-dom';
import CloudAICalculator from '../components/calculator/CloudAICalculator';
import LocalAICalculator from '../components/calculator/LocalAICalculator';
import AgenticAICalculator from '../components/calculator/AgenticAICalculator';

const CalculatorPage = ({ onCalculationComplete }) => {
  const [calculatorType, setCalculatorType] = useState('cloud');
  
  return (
    <div className="container">
      <div className="content-area">
        <h1>AI Footprint Calculator</h1>
        <p className="info-text">
          Select the type of AI usage you want to calculate the environmental footprint for.
        </p>
        
        <div className="calculator-selector">
          <button 
            className={calculatorType === 'cloud' ? 'button' : 'button secondary'}
            onClick={() => setCalculatorType('cloud')}
          >
            Cloud AI
          </button>
          <button 
            className={calculatorType === 'local' ? 'button' : 'button secondary'}
            onClick={() => setCalculatorType('local')}
          >
            Local AI
          </button>
          <button 
            className={calculatorType === 'agentic' ? 'button' : 'button secondary'}
            onClick={() => setCalculatorType('agentic')}
          >
            Agentic AI
          </button>
        </div>
        
        <div className="calculator-container">
          {calculatorType === 'cloud' && <CloudAICalculator onCalculationComplete={onCalculationComplete} />}
          {calculatorType === 'local' && <LocalAICalculator onCalculationComplete={onCalculationComplete} />}
          {calculatorType === 'agentic' && <AgenticAICalculator onCalculationComplete={onCalculationComplete} />}
        </div>
      </div>
    </div>
  );
};

export default CalculatorPage;
