module.exports = function(eleventyConfig) {
  // Copy static assets
  eleventyConfig.addPassthroughCopy("css");
  eleventyConfig.addPassthroughCopy("js");
  eleventyConfig.addPassthroughCopy("img");
  
  // Set input and output directories
  return {
    dir: {
      input: ".",
      output: "_site",
      includes: "_includes"
    },
    // Process both .njk and .md files
    templateFormats: ["njk", "md"],
    // Use nunjucks for templating
    markdownTemplateEngine: "njk",
    htmlTemplateEngine: "njk"
  };
};
