import React from 'react';
import { Link } from 'react-router-dom';

const HomePage = () => {
  return (
    <div className="container">
      <section className="hero">
        <div className="content-area">
          <h1>AI Footprint Calculator</h1>
          <p className="info-text">
            Estimate the environmental impact of your artificial intelligence usage and discover ways to offset it.
          </p>
          <div className="cta-buttons">
            <Link to="/calculator" className="button">Start Calculation</Link>
            <Link to="/methodology" className="button secondary">Learn More</Link>
          </div>
        </div>
      </section>
      
      <section className="features">
        <div className="grid">
          <div className="feature-card content-area">
            <h2>Cloud AI</h2>
            <p className="info-text">Calculate the footprint of cloud-based AI services like GPT-4, Claude, and DALL-E.</p>
          </div>
          <div className="feature-card content-area">
            <h2>Local AI</h2>
            <p className="info-text">Estimate energy usage from running AI models on your own hardware.</p>
          </div>
          <div className="feature-card content-area">
            <h2>Agentic AI</h2>
            <p className="info-text">Understand the combined impact of AI agents that orchestrate multiple models.</p>
          </div>
        </div>
      </section>
      
      <section className="about content-area">
        <h2>About the Calculator</h2>
        <p className="info-text">
          The AI Footprint Calculator provides reasonable estimates of the operational environmental footprint 
          (energy consumption, water usage, and carbon emissions) of artificial intelligence activities. 
          Our calculations are based on publicly available research and benchmarks.
        </p>
        <p className="info-text">
          This tool aims to promote awareness and encourage more sustainable AI practices by making 
          the environmental costs of AI usage more transparent and understandable.
        </p>
      </section>
    </div>
  );
};

export default HomePage;
