import React from 'react';

const MethodologyPage = () => {
  return (
    <div className="container">
      <div className="content-area">
        <h1>Methodology & Data Sources</h1>
        <p className="info-text">
          Learn about the methodology, data sources, and assumptions behind the AI Footprint Calculator.
        </p>
        
        <section className="methodology-section">
          <h2>Core Philosophy</h2>
          <p className="info-text">
            The AI Footprint Calculator provides reasonable estimates based on publicly available research, 
            benchmarks, and clearly stated assumptions. We acknowledge that precise footprint data for all 
            AI systems is often scarce or proprietary.
          </p>
          <p className="info-text">
            Our goal is to provide transparency about the environmental costs of AI usage while 
            empowering users with actionable guidance for offsetting their impact.
          </p>
        </section>
        
        <section className="methodology-section">
          <h2>Cloud AI Footprint Methodology</h2>
          <p className="info-text">
            Our cloud AI footprint estimates are based on a tiered system for different AI categories. 
            Each tier represents a range of energy consumption values derived from published research, 
            benchmarks, and reasonable extrapolations.
          </p>
          
          <h3>Key Assumptions</h3>
          <ul>
            <li className="info-text"><strong>PUE (Power Usage Effectiveness):</strong> 1.12 (representative of efficient hyperscalers)</li>
            <li className="info-text"><strong>WUE_site (Water Usage Effectiveness, on-site cooling):</strong> 0.30 L/kWh_IT</li>
            <li className="info-text"><strong>WUE_source (Water Usage Effectiveness, off-site electricity generation):</strong> Varies by region</li>
          </ul>
          
          <h3>Water Calculation Formula</h3>
          <div className="formula-box content-area">
            <p>Water_direct (mL) = (Energy_IT (Wh/unit) / 1000) * WUE_site (L/kWh_IT) * 1000</p>
            <p>Water_indirect (mL) = (Energy_IT (Wh/unit) / 1000 * PUE) * WUE_source (L/kWh_grid) * 1000</p>
            <p>Total_Water = Water_direct + Water_indirect</p>
          </div>
        </section>
        
        <section className="methodology-section">
          <h2>Local AI Footprint Methodology</h2>
          <p className="info-text">
            Local AI footprint estimates are based on hardware profiles and task types. 
            We provide representative system power draw values for common hardware configurations 
            during AI tasks.
          </p>
          
          <h3>Energy Calculation</h3>
          <div className="formula-box content-area">
            <p>Energy (Wh) = Representative_System_Power_Profile (W) * Task_Duration (h)</p>
          </div>
          
          <p className="info-text">
            For advanced users, we allow direct input of measured system power and task duration.
          </p>
        </section>
        
        <section className="methodology-section">
          <h2>Agentic AI Methodology</h2>
          <p className="info-text">
            Agentic AI footprint is calculated by summing the orchestrator overhead 
            (reasoning/planning calls to an LLM) and the discrete sub-tasks performed by the agent.
          </p>
        </section>
        
        <section className="methodology-section">
          <h2>Data Sources</h2>
          <p className="info-text">
            Our calculator draws from multiple research sources, including:
          </p>
          <ul>
            <li className="info-text">Published academic papers on AI energy consumption</li>
            <li className="info-text">Industry benchmarks and technical reports</li>
            <li className="info-text">Hardware manufacturer specifications</li>
            <li className="info-text">Grid carbon intensity data from electricity maps and regional authorities</li>
            <li className="info-text">Water usage data from data center industry reports</li>
          </ul>
        </section>
        
        <section className="methodology-section">
          <h2>Limitations & Uncertainty</h2>
          <p className="info-text">
            The calculator has several known limitations:
          </p>
          <ul>
            <li className="info-text">Estimates are based on available data, which may not perfectly match all AI systems</li>
            <li className="info-text">Actual energy consumption varies based on specific hardware, optimization, and utilization</li>
            <li className="info-text">Water consumption estimates have higher uncertainty than energy estimates</li>
            <li className="info-text">The calculator focuses on operational footprint, not embodied footprint of hardware</li>
            <li className="info-text">Emerging AI technologies may not be accurately represented</li>
          </ul>
          <p className="info-text">
            To account for these uncertainties, we recommend using the offsetting buffer feature 
            to ensure adequate coverage of your environmental impact.
          </p>
        </section>
      </div>
    </div>
  );
};

export default MethodologyPage;
