import React from 'react';

const OffsettingPage = () => {
  return (
    <div className="container">
      <div className="content-area">
        <h1>Offsetting Guidance</h1>
        <p className="info-text">
          Learn how to offset the environmental footprint of your AI usage through carbon and water credits.
        </p>
        
        <section className="offsetting-section">
          <h2>Understanding Carbon Credits</h2>
          <p className="info-text">
            Carbon credits represent the reduction or removal of one metric ton of carbon dioxide (or equivalent greenhouse gases) from the atmosphere. 
            By purchasing carbon credits, you fund projects that either prevent emissions or remove carbon from the atmosphere.
          </p>
          <h3>Key Quality Criteria</h3>
          <ul>
            <li className="info-text"><strong>Additionality:</strong> The project wouldn't have happened without carbon credit funding.</li>
            <li className="info-text"><strong>Permanence:</strong> Carbon reductions or removals are long-lasting.</li>
            <li className="info-text"><strong>Leakage Prevention:</strong> Emissions aren't simply moved elsewhere.</li>
            <li className="info-text"><strong>Verification:</strong> Independent third parties verify the project's impact.</li>
            <li className="info-text"><strong>Co-benefits:</strong> Additional positive social or environmental impacts.</li>
          </ul>
        </section>
        
        <section className="offsetting-section">
          <h2>Understanding Water Credits</h2>
          <p className="info-text">
            Water credits (or Water Restoration Certificates) represent the restoration of 1,000 gallons of water to a specific ecosystem. 
            By purchasing water credits, you fund projects that restore water to dewatered ecosystems.
          </p>
          <h3>Key Quality Criteria</h3>
          <ul>
            <li className="info-text"><strong>Volumetric Benefit:</strong> Measurable water volume restored.</li>
            <li className="info-text"><strong>Water Stress Context:</strong> Projects in water-stressed regions.</li>
            <li className="info-text"><strong>Ecological Uplift:</strong> Positive impact on local ecosystems.</li>
            <li className="info-text"><strong>Verification:</strong> Independent verification of water restoration.</li>
          </ul>
        </section>
        
        <section className="offsetting-section">
          <h2>Reputable Carbon Credit Providers</h2>
          <div className="provider-list">
            <div className="provider-card content-area">
              <h3>CNaught</h3>
              <p className="info-text">Offers high-quality carbon removal credits with transparent verification.</p>
              <p className="info-text"><strong>Standards:</strong> Gold Standard, Verra</p>
              <p className="info-text"><strong>Project Types:</strong> Direct Air Capture, Enhanced Weathering, Biochar</p>
              <a href="https://www.cnaught.com" target="_blank" rel="noopener noreferrer" className="button secondary">Visit Website</a>
            </div>
            
            <div className="provider-card content-area">
              <h3>Patch</h3>
              <p className="info-text">API-first platform for carbon removal with diverse project portfolio.</p>
              <p className="info-text"><strong>Standards:</strong> Gold Standard, Verra, CAR, ACR</p>
              <p className="info-text"><strong>Project Types:</strong> Forestry, Soil Carbon, Direct Air Capture, Biochar</p>
              <a href="https://www.patch.io" target="_blank" rel="noopener noreferrer" className="button secondary">Visit Website</a>
            </div>
            
            <div className="provider-card content-area">
              <h3>Cool Effect</h3>
              <p className="info-text">Non-profit platform with carefully vetted carbon reduction projects.</p>
              <p className="info-text"><strong>Standards:</strong> Gold Standard, Verra, CAR, ACR</p>
              <p className="info-text"><strong>Project Types:</strong> Forestry, Renewable Energy, Cookstoves, Methane Capture</p>
              <a href="https://www.cooleffect.org" target="_blank" rel="noopener noreferrer" className="button secondary">Visit Website</a>
            </div>
          </div>
        </section>
        
        <section className="offsetting-section">
          <h2>Reputable Water Credit Providers</h2>
          <div className="provider-list">
            <div className="provider-card content-area">
              <h3>Bonneville Environmental Foundation (BEF)</h3>
              <p className="info-text">Pioneers in water restoration certificates with verified impact.</p>
              <p className="info-text"><strong>Standards:</strong> BEF Water Restoration Certificates</p>
              <p className="info-text"><strong>Project Types:</strong> Flow Restoration, Irrigation Efficiency, Water Rights Acquisition</p>
              <a href="https://www.b-e-f.org" target="_blank" rel="noopener noreferrer" className="button secondary">Visit Website</a>
            </div>
          </div>
        </section>
        
        <section className="offsetting-section">
          <h2>Due Diligence Checklist</h2>
          <p className="info-text">When evaluating credit providers, consider the following:</p>
          <ul>
            <li className="info-text">Is there third-party verification of the projects?</li>
            <li className="info-text">Are projects listed in a public registry?</li>
            <li className="info-text">Are detailed project documents available?</li>
            <li className="info-text">Is there clear evidence of additionality?</li>
            <li className="info-text">How is permanence ensured?</li>
            <li className="info-text">How is leakage prevented?</li>
            <li className="info-text">What co-benefits do the projects provide?</li>
            <li className="info-text">Is there host country approval?</li>
            <li className="info-text">Is the provider transparent about fees and pricing?</li>
            <li className="info-text">Is there a clear process for credit retirement?</li>
          </ul>
        </section>
        
        <div className="disclaimer-box">
          <p className="info-text">
            <strong>Disclaimer:</strong> This information is provided for educational purposes only. 
            The listing of providers does not constitute an endorsement. 
            We recommend conducting your own research before purchasing carbon or water credits.
          </p>
        </div>
      </div>
    </div>
  );
};

export default OffsettingPage;
