# AI Footprint Calculator Microsite - Deployment Instructions

## Overview

This document provides instructions for deploying the AI Footprint Calculator Microsite to your web server or hosting platform. The microsite is a static site built with 11ty (Eleventy) and requires no server-side processing or database.

## Package Contents

The `ai-footprint-microsite.zip` file contains:

1. **Source Files**:
   - All source code in the project root
   - Content files in `.njk` format
   - CSS and JavaScript in their respective directories
   - Configuration files for 11ty

2. **Built Site**:
   - The complete built site in the `_site` directory
   - Ready-to-deploy HTML, CSS, and JavaScript files

## Deployment Options

### Option 1: Deploy Pre-built Files (Recommended)

1. Extract the `ai-footprint-microsite.zip` file
2. Locate the `_site` directory which contains the complete built site
3. Upload all contents of the `_site` directory to your web server or hosting platform
4. No build step is required as these are static HTML, CSS, and JS files

### Option 2: Build and Deploy from Source

If you want to modify the site before deployment:

1. Extract the `ai-footprint-microsite.zip` file
2. Ensure you have Node.js installed (v14 or later recommended)
3. Open a terminal in the extracted directory
4. Run `npm install` to install dependencies
5. Make any desired changes to the content or styling
6. Run `npm run build` to generate the site
7. Upload the contents of the `_site` directory to your web server

## Server Requirements

- Any web server capable of serving static files (Apache, Nginx, etc.)
- No special server configuration is needed
- No database or server-side processing required

## Subdomain Configuration

To deploy to a subdomain on your website:

1. Create or configure the desired subdomain in your DNS settings
2. Upload the contents of the `_site` directory to the subdomain's root directory
3. Ensure your web server is configured to serve the subdomain

## Testing

After deployment, verify that:

1. All pages are accessible
2. Navigation links work correctly
3. Styling is applied properly
4. The site is responsive on different devices

## Support

If you encounter any issues with deployment, please refer to:
- 11ty documentation: https://www.11ty.dev/docs/
- Your web hosting provider's documentation for static site deployment

## License and Attribution

This microsite was created as a case study of the AI Footprint Calculator project. All content is provided for educational purposes.
