// Minimal JavaScript for the AI Footprint Calculator Microsite

document.addEventListener('DOMContentLoaded', function() {
  // Add keyboard navigation support
  setupKeyboardNavigation();
  
  // Add CRT scan line effect animation
  setupCRTEffect();
});

// Setup keyboard navigation for accessibility
function setupKeyboardNavigation() {
  // Add focus styles and keyboard navigation between sections
  const navLinks = document.querySelectorAll('nav a');
  
  // Enable arrow key navigation between nav items when focused
  navLinks.forEach((link, index) => {
    link.addEventListener('keydown', (e) => {
      // Right arrow or down arrow
      if (e.key === 'ArrowRight' || e.key === 'ArrowDown') {
        e.preventDefault();
        const nextIndex = (index + 1) % navLinks.length;
        navLinks[nextIndex].focus();
      }
      
      // Left arrow or up arrow
      if (e.key === 'ArrowLeft' || e.key === 'ArrowUp') {
        e.preventDefault();
        const prevIndex = (index - 1 + navLinks.length) % navLinks.length;
        navLinks[prevIndex].focus();
      }
    });
  });
}

// Setup subtle CRT effect animation
function setupCRTEffect() {
  // Add subtle flicker effect to enhance CRT aesthetic
  const body = document.body;
  
  // Random subtle brightness fluctuation
  setInterval(() => {
    const flickerAmount = 0.98 + Math.random() * 0.04; // Between 0.98 and 1.02
    body.style.opacity = flickerAmount;
  }, 100);
}
