# AI Footprint Calculator - Migration Instructions

## Overview

This document provides instructions for migrating the AI Footprint Calculator web application to your subdomain.

## Project Structure

The application is a React-based single-page application built with Vite. The production build is located in the `dist` directory and is ready for deployment.

## Migration Steps

### Option 1: Deploy the Production Build

1. Extract the `ai-footprint-calculator.zip` file
2. Copy the contents of the `dist` directory to your web server's root directory for your subdomain
3. Configure your web server to serve the `index.html` file for all routes (for SPA routing)

### Option 2: Build from Source

If you need to make modifications before deployment:

1. Extract the `ai-footprint-calculator.zip` file
2. Install dependencies: `npm install`
3. Make any necessary changes to the source code
4. Build the production version: `npm run build`
5. Copy the contents of the `dist` directory to your web server

## Server Configuration

### Apache

Add this to your `.htaccess` file:

```
<IfModule mod_rewrite.c>
  RewriteEngine On
  RewriteBase /
  RewriteRule ^index\.html$ - [L]
  RewriteCond %{REQUEST_FILENAME} !-f
  RewriteCond %{REQUEST_FILENAME} !-d
  RewriteRule . /index.html [L]
</IfModule>
```

### Nginx

Add this to your server block:

```
location / {
  try_files $uri $uri/ /index.html;
}
```

## Customization

- To change the title or meta description: Edit the `index.html` file
- To update calculation data: Modify the `src/utils/calculationEngine.js` file and rebuild

## Technical Details

- Frontend Framework: React 18
- Build Tool: Vite
- Routing: React Router DOM
- Styling: CSS Modules with CSS variables
- Charts: Chart.js with React-Chartjs-2

## Support

If you encounter any issues during migration, please reach out for assistance.
