# AI Footprint Calculator - Requirements and Data Sources

## 1. Core Functionality Requirements

### 1.1 Cloud AI Footprint Estimation
- **Tiered System**: Implement a tiered system for different AI categories
- **User Inputs**: 
  - AI task type
  - Specific model or generic tier
  - Volume of use (queries, images, tokens, etc.)
  - Primary compute region (for grid carbon intensity)
- **AI Categories & Tiers**:
  - Text Generation (3 tiers)
  - Image Generation (2 tiers)
  - Video Generation (1 tier for MVP)
  - Audio Generation (1 tier for MVP)
  - Analytical/Classification Tasks (1 tier)
- **Named Models Mapping**: Map popular models to appropriate tiers
- **Metrics Calculation**:
  - Energy consumption (Wh or kWh)
  - Water consumption (mL or Liters)
  - Carbon emissions (gCO2e or kgCO2e)

### 1.2 Local AI Footprint Estimation
- **Estimation Levels**:
  - Level 1 (Basic): Hardware category + AI task type
  - Level 3 (Advanced): User-provided power measurements
- **User Inputs (Level 1)**:
  - Hardware category
  - Local AI task type
  - Estimated task duration/number of outputs
  - User's region/country
- **User Inputs (Level 3)**:
  - Measured average system power
  - Actual task duration
  - User's region/country
- **Hardware Categories**:
  - High-End GPU Desktop
  - Mid-Range GPU Desktop
  - Entry GPU Desktop/CPU-only
  - High-Performance AI Laptop
  - Standard Laptop (iGPU/NPU)
  - Apple M-Series Laptop

### 1.3 Agentic AI Platform Footprint Estimation
- **Mechanism**: User deconstructs agent's task into constituent AI calls
- **Components**:
  - Orchestrator overhead (reasoning/planning calls)
  - Discrete sub-tasks (individual AI operations)
- **Default Values**: 3-5 calls to Text Gen Tier 2 for orchestration

### 1.4 Aggregation & Totals
- **Activity Definition**: Users define multiple "AI Activities"
- **Frequency Specification**: Per day/week/month or one-off project
- **Timeframe Totals**: Daily, Weekly, Monthly, and Yearly aggregations
- **Distinction**: Clear separation between recurring and one-off contributions

### 1.5 Offsetting Guidance
- **Credit Calculation**: Display equivalent carbon and water credits needed
- **Educational Content**:
  - Carbon credits explanation
  - Water credits explanation
  - Verification standards information
  - Credit pricing factors
- **Provider Lists**:
  - 3-5 carbon credit providers
  - 1-3 water credit providers
- **Due Diligence Checklist**: For evaluating credit providers
- **Uncertainty Buffer**: User-selectable buffer/safety margin (0-100%)

### 1.6 User Accounts & Data Persistence
- **Authentication**: Email/password login
- **Data Saving**: Save recurring activities and preferences
- **Profile Management**: Enable meaningful calculation of aggregated totals

## 2. Data Requirements

### 2.1 Cloud AI Footprint Data
- **PUE Assumption**: 1.12 (efficient hyperscalers)
- **WUE Assumptions**:
  - WUE_site: 0.30 L/kWh_IT
  - WUE_source: Varies by region
- **Water Calculation Formula**:
  - Water_direct (mL) = (Energy_IT (Wh/unit) / 1000) * WUE_site (L/kWh_IT) * 1000
  - Water_indirect (mL) = (Energy_IT (Wh/unit) / 1000 * PUE) * WUE_source (L/kWh_grid) * 1000
  - Total_Water = Water_direct + Water_indirect

### 2.2 Tier-Specific Energy & Water Data
- **Text Generation**:
  - Tier 1: 0.002-0.2 Wh, 0.01-2.0 mL per query
  - Tier 2: 0.3-3.0 Wh, 1.5-15 mL per interaction
  - Tier 3: 5-40+ Wh, 20-300+ mL per complex query
- **Image Generation**:
  - Tier 1: 0.1-1.0 Wh, 0.05-0.5 mL per image
  - Tier 2: 1.0-12.0+ Wh, 0.5-40 mL per image
- **Video Generation**:
  - Tier 1: 1.0-5.0 Wh, 0.35-2.0 mL per second
- **Audio Generation**:
  - Tier 1: 0.001-0.05 Wh, 0.00035-0.02 mL per minute
- **Analytical/Classification**:
  - Tier 1: 0.002-0.04 Wh, 0.0007-0.016 mL per query

### 2.3 Local AI Hardware Profiles
- **System Power Draw During AI Tasks**:
  - High-End GPU Desktop: LLM (350-550W), Image (300-500W)
  - Mid-Range GPU Desktop: LLM (200-350W), Image (180-300W)
  - Entry GPU Desktop/CPU-only: LLM (100-200W/80-180W), Image (100-180W)
  - High-Performance AI Laptop: LLM (100-200W), Image (90-180W)
  - Standard Laptop: LLM (20-60W), Image (25-70W)
  - Apple M-Series Laptop: LLM (15-45W), Image (20-50W)
- **Energy Calculation**: Energy (Wh) = Power (W) * Duration (h)
- **Performance Rates**: Convert outputs to duration using tok/s, img/s rates

## 3. UI/UX Requirements

### 3.1 Style Guide
- **Overall Vision**: Minimalist, high-resolution, white-on-black, modern CRT
- **Color Palette**:
  - Page Background: #000000 (Pure Black)
  - Main Content Area: #0D0D0D (Very Dark Grey)
  - Primary Text: #FFFFFF (White)
  - Secondary Text: #B0B0B0 (Light Grey)
  - Tertiary Text/Borders: #707070 (Medium Grey)
  - Focus Outline: #FFFFFF (White), 2px solid/dashed
- **Typography**:
  - Primary UI Font: IBM Plex Mono (fallbacks: Consolas, Menlo, Monaco)
  - Informational Text: IBM Plex Sans (fallbacks: Inter, Roboto)
  - Sizes: H1 (32px), H2 (24px), Body/Labels (15px), Info Body (16px)
- **UI Elements**:
  - Primary Buttons: Transparent bg, white text/border
  - Secondary Buttons: Transparent bg, light grey text, medium grey border
  - Text Links: Light grey, bold, underlined
  - Input Fields: Black bg, white text, medium grey border/placeholder
  - Dropdown Menus: Dark grey bg, white text
  - Radio/Checkboxes: White outlined, white fill when selected
  - Icons: Simple, white/light grey line-art

### 3.2 Page Structure
1. **Homepage**: Introduction, CTA
2. **Calculator Input**: Define/manage AI activities
3. **User Profile**: Login/register, saved activities
4. **Results Dashboard**: Aggregated totals, visualizations, credits, buffer
5. **Offsetting Guidance Hub**: Education, provider lists, checklist
6. **Methodology/About**: Assumptions, data sources, limitations

### 3.3 User Flow
1. Homepage → Start Calculation
2. (Optional) Login/Register or use templates
3. Define AI Activities
4. View Results Dashboard
5. Explore Offsetting Guidance
6. (If registered) Save configurations

## 4. Technical Requirements

### 4.1 Data Management
- Embed tier data, hardware profiles, PUE/WUE values, grid emission factors, and provider lists in backend data structures
- Support manual updates for the MVP

### 4.2 Calculation Engine
- Implement formulas for energy, water, and carbon calculations
- Support different estimation levels for local AI
- Enable aggregation across activities and timeframes

### 4.3 Uncertainty Communication
- Display clear disclaimers about estimates
- Provide explanations of key uncertainty sources
- Implement user-selectable offsetting buffer

## 5. Data Sources

### 5.1 Cloud AI Footprint
- Energy and water consumption data from research reports
- Grid carbon intensity factors by region
- PUE and WUE values from "How Hungry is AI?" methodology

### 5.2 Local AI Footprint
- Hardware power profiles from "Local AI Data PDF"
- Performance rates (tok/s, img/s) from research tables
- System power draw during different AI tasks

### 5.3 Offsetting Guidance
- Carbon credit provider information
- Water credit provider information
- Verification standards data
- Due diligence checklist criteria

## 6. Open Questions for User Clarification
1. Technology stack preferences (frontend, backend)
2. Authentication system and database technology preferences
3. MVP feature prioritization
4. Additional design requirements beyond style guide
5. Deployment preferences and infrastructure
